<?php $__env->startSection('title', $service->name . ' - ENT Care Center'); ?>
<?php $__env->startSection('meta_description', $service->description); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<!-- Page Header -->
<section class="relative h-[40vh] min-h-[400px] flex items-center justify-center overflow-hidden bg-primary-900">
    <div class="absolute inset-0 bg-gradient-to-br from-primary-900 via-primary-800 to-primary-900 opacity-90"></div>
    <div class="absolute inset-0 bg-[url('/img/pattern.png')] opacity-10"></div>
    
    <!-- Animated shapes -->
    <div class="absolute top-20 left-10 w-64 h-64 bg-primary-500/20 rounded-full blur-3xl animate-pulse-slow"></div>
    <div class="absolute bottom-10 right-10 w-80 h-80 bg-accent-500/20 rounded-full blur-3xl animate-pulse-slow" style="animation-delay: 1s;"></div>
    
    <div class="relative z-10 text-center text-white px-4 max-w-4xl mx-auto">
        <nav aria-label="breadcrumb" class="mb-6">
            <ol class="flex flex-wrap justify-center items-center space-x-2 text-sm text-primary-200">
                <li><a href="<?php echo e(route('home')); ?>" class="hover:text-white transition-colors">Home</a></li>
                <li><span class="text-primary-400">/</span></li>
                <li><a href="<?php echo e(route('services.index')); ?>" class="hover:text-white transition-colors">Services</a></li>
                <li><span class="text-primary-400">/</span></li>
                <li class="text-white font-medium"><?php echo e($service->name); ?></li>
            </ol>
        </nav>
        <h1 class="text-4xl sm:text-5xl md:text-6xl font-bold mb-4 tracking-tight"><?php echo e($service->name); ?></h1>
    </div>
</section>

<!-- Service Detail -->
<section class="py-20 bg-secondary-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 lg:gap-12">
            <div class="lg:col-span-2">
                <div class="bg-white rounded-3xl p-8 shadow-sm border border-secondary-100">
                    <?php if($service->icon): ?>
                    <div class="mb-8">
                        <div class="inline-flex items-center justify-center w-20 h-20 bg-primary-50 text-primary-600 rounded-2xl">
                            <i class="<?php echo e($service->icon); ?> text-4xl"></i>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <div class="mb-8">
                        <h2 class="text-2xl font-bold text-secondary-900 mb-4">Overview</h2>
                        <p class="text-lg text-secondary-600 leading-relaxed"><?php echo e($service->description); ?></p>
                    </div>

                    <?php if($service->full_description): ?>
                    <div class="prose prose-lg prose-slate max-w-none text-secondary-600">
                        <?php echo nl2br(e($service->full_description)); ?>

                    </div>
                    <?php else: ?>
                    <div class="prose prose-lg prose-slate max-w-none text-secondary-600">
                        <p>
                            Our experienced team of ENT specialists is trained in the latest techniques and uses state-of-the-art equipment to provide you with the best possible care. We understand that every patient is unique, and we work closely with you to develop a personalized treatment plan that addresses your specific needs and concerns.
                        </p>
                        <p>
                            During your consultation, our specialists will conduct a thorough evaluation, discuss your symptoms and medical history, and explain all available treatment options. We believe in patient education and will ensure you fully understand your condition and the recommended treatment approach.
                        </p>
                    </div>
                    <?php endif; ?>

                    <!-- What to Expect -->
                    <div class="mt-12 bg-primary-50/50 rounded-2xl p-8 border border-primary-100">
                        <h3 class="text-xl font-bold text-secondary-900 mb-6 flex items-center">
                            <span class="w-1.5 h-6 bg-primary-500 rounded-full mr-3"></span>
                            What to Expect
                        </h3>
                        <ul class="space-y-4">
                            <li class="flex items-start">
                                <span class="flex-shrink-0 w-6 h-6 bg-primary-100 text-primary-600 rounded-full flex items-center justify-center mt-1 mr-4">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                    </svg>
                                </span>
                                <span class="text-secondary-700">Comprehensive evaluation and diagnosis using advanced technology</span>
                            </li>
                            <li class="flex items-start">
                                <span class="flex-shrink-0 w-6 h-6 bg-primary-100 text-primary-600 rounded-full flex items-center justify-center mt-1 mr-4">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                    </svg>
                                </span>
                                <span class="text-secondary-700">Personalized treatment plan tailored to your specific needs</span>
                            </li>
                            <li class="flex items-start">
                                <span class="flex-shrink-0 w-6 h-6 bg-primary-100 text-primary-600 rounded-full flex items-center justify-center mt-1 mr-4">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                    </svg>
                                </span>
                                <span class="text-secondary-700">Clear communication and ongoing support throughout your care</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <div class="lg:col-span-1 space-y-8">
                <div class="bg-white rounded-2xl p-8 shadow-sm border border-secondary-100">
                    <h3 class="text-xl font-bold text-secondary-900 mb-4">Book Consultation</h3>
                    <p class="text-secondary-600 mb-6">Interested in this service? Schedule an appointment with our specialists today.</p>
                    <a href="<?php echo e(route('appointment.create')); ?>" 
                       class="block w-full text-center px-6 py-4 bg-primary-600 text-white rounded-xl font-bold hover:bg-primary-700 hover:shadow-lg hover:-translate-y-1 transition-all duration-300">
                        Book Appointment
                    </a>
                </div>
                
                <div class="bg-secondary-50 rounded-2xl p-8 border border-secondary-100">
                    <h3 class="text-lg font-bold text-secondary-900 mb-4">Other Services</h3>
                    <ul class="space-y-3">
                        <li>
                            <a href="<?php echo e(route('services.index')); ?>" 
                               class="flex items-center text-secondary-600 hover:text-primary-600 font-medium transition-colors p-2 hover:bg-white rounded-lg group">
                                <span class="w-1.5 h-1.5 bg-secondary-300 rounded-full mr-3 group-hover:bg-primary-500 transition-colors"></span>
                                View All Services
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('about')); ?>" 
                               class="flex items-center text-secondary-600 hover:text-primary-600 font-medium transition-colors p-2 hover:bg-white rounded-lg group">
                                <span class="w-1.5 h-1.5 bg-secondary-300 rounded-full mr-3 group-hover:bg-primary-500 transition-colors"></span>
                                Meet Our Doctors
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('contact.index')); ?>" 
                               class="flex items-center text-secondary-600 hover:text-primary-600 font-medium transition-colors p-2 hover:bg-white rounded-lg group">
                                <span class="w-1.5 h-1.5 bg-secondary-300 rounded-full mr-3 group-hover:bg-primary-500 transition-colors"></span>
                                Contact Us
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-20 bg-primary-600 relative overflow-hidden">
    <!-- Decorative patterns -->
    <div class="absolute top-0 left-0 -ml-20 -mt-20 w-80 h-80 rounded-full bg-primary-500 opacity-20 blur-3xl"></div>
    <div class="absolute bottom-0 right-0 -mr-20 -mb-20 w-80 h-80 rounded-full bg-accent-500 opacity-20 blur-3xl"></div>
    
    <div class="relative z-10 max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center text-white">
        <h2 class="text-3xl md:text-5xl font-bold mb-6 tracking-tight">Ready to Get Started?</h2>
        <p class="text-lg md:text-xl mb-10 text-primary-100 font-light max-w-2xl mx-auto">Schedule your consultation today and experience expert ENT care.</p>
        <a href="<?php echo e(route('appointment.create')); ?>" 
           class="inline-flex items-center space-x-2 px-8 py-4 bg-white text-primary-600 rounded-xl font-bold text-lg shadow-xl hover:shadow-2xl hover:-translate-y-1 transition-all duration-300">
            <span>Book Appointment</span>
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
            </svg>
        </a>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.modern', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/sumankc/Desktop/ Websites/ENT Care/resources/views/services/show.blade.php ENDPATH**/ ?>